--Funkcije

--Zaokruivanje
--ROUND( numeriki_izraz, duljina )
SELECT ROUND(42.16944, 3)

--najvei cijeli broj manji ili jednak danom numerikom
--FLOOR( numeriki_izraz )
SELECT FLOOR(42.45), FLOOR(-42.16), CEILING(42.45), CEILING(-42.16)


--kvadrat broja
SELECT SQUARE(16), SQUARE(3), SQRT(9)

--potencija broja
--POWER( float_izraz, y)
SELECT POWER(2, 3), POWER(4, 2), POWER(2, 10)

--apsolutna vrijednost broja
SELECT ABS(-10)

--vraa -1 za negativni broj, 0 za 0 i 1 za pozitivni broj
SELECT SIGN(-3), SIGN(0), SIGN(10)  

--sluajni broj izmeu 0 i 1 (granice iskljuene) 
SELECT RAND()


--string funkcije
SELECT LEFT('www.racunarstvo.hr', 5),
	RIGHT('www.racunarstvo.hr', 5),
	REVERSE('www.racunarstvo.hr'),
	SUBSTRING('www.racunarstvo.hr', 5, 11),
	UPPER('www.racunarstvo.hr'),
	LOWER('WWW.racunarstvo.HR')
	
SELECT 
	'    Pero ide u umu     ',
	LTRIM('    Pero ide u umu     '),
	RTRIM('    Pero ide u umu     ')
	
SELECT REPLACE('Pero ide u umu', 'Pero', 'Jura')

SELECT LEN('www.racunarstvo.hr')

SELECT CHARINDEX('www.', 'www.racunarstvo.hr'),
	CHARINDEX('.hr', 'www.racunarstvo.hr'),
	CHARINDEX('ovog nema', 'www.racunarstvo.hr'),
	CHARINDEX('r', 'www.racunarstvo.hr'),
	CHARINDEX('r', 'www.racunarstvo.hr',6)
		

-- funkcije pretvaranja i provjere podataka
SELECT CAST(45.67 as nvarchar(5))
SELECT CONVERT(VARCHAR(12),GETDATE(), 104) -- 4

SELECT CAST(GETDATE() AS DATE)
SELECT CAST(GETDATE() AS TIME)

SELECT GETDATE()
SELECT cast(GETDATE() as float)
SELECT CAST(FLOOR(CAST(GETDATE() AS FLOAT)) AS datetime)

SELECT ISDATE('2015-12-5')
SELECT telefon from kupac where ISNUMERIC(telefon)=1

SELECT isnull(boja, 'N/A') from proizvod


--datumske funkcije
SELECT GETDATE()

SELECT DATEPART(year, GETDATE() ) 'Godina',
	DATEPART(month, GETDATE() ) 'Mjesec',
	DATEPART(day, GETDATE() ) 'Dan',
	DATEPART(week, GETDATE() ) 'Tjedan'
		--year, quarter, month, dayofyear, day, week, weekday, hour, minute, second

SELECT YEAR(GETDATE()), MONTH(GETDATE()), DAY(GETDATE())

SELECT DATEADD(year, 2, GETDATE() ),
	DATEADD(month, 3, GETDATE() ),
	DATEADD(day, 365, GETDATE() )


SELECT DATEADD(year, 1, '20150216')
SELECT DATEADD(year, 1, '20160216')
SELECT DATEADD(year, 1, '20160229')
SELECT DATEADD(day, 365, '20150216')
SELECT DATEADD(day, 365, '20160216')

SELECT 
DATEDIFF(day, '19901016', GETDATE()) AS 'Razlika u danima',
DATEDIFF(day, GETDATE(), '19901016') AS 'Razlika u danima',
DATEDIFF(month, '19901016', GETDATE() ) AS 'Razlika u mjesecima',
DATEDIFF(year, '19901016', GETDATE() ) AS 'Razlika u godinama'


-- agregatne funkcije

-- Prebrojimo koliko videoteka Lo Film ima zapisanih filmova u bazi LosFilm:

USE LosFilm
GO

SELECT COUNT(*) as 'Broj filmova' FROM Film


-- Koliko ima filmova anra SF?
SELECT COUNT(*) as 'Broj filmova anra SF' 
	FROM Film 
	INNER JOIN Zanr ON Film.ZanrID = Zanr.ID
		WHERE Zanr.Naziv = 'SF'
		
-- Zadaci
-- 1. Ispiite koliko traje najkrai, a koliko najdui film.
select min(f.trajanje) as NajkraeTrajanje, max(f.trajanje) as NajdueTrajanje
from film as f

-- 2. Ispiite prosjeno trajanje svih filmova.
SELECT AVG(Trajanje) N'Prosjeno trajanje filmova' FROM Film
GO

-- 3. Ispiite prosjeno trajanje filmova anra SF.
SELECT AVG(Trajanje) N'Prosjeno trajanje filmova anra SF' 
	FROM Film 
	INNER JOIN Zanr ON Film.ZanrID = Zanr.ID
		WHERE Zanr.Naziv = 'SF'
GO

-- 4. Ispiite u kojim sve mjesecima su posuivani filmovi.
SELECT DISTINCT
	MONTH(DatumPosudbe) AS N'Mjeseci u kojima su posuivani filmovi'
	FROM Posudba
GO

-- 5. Ispiite koliko filmova je posueno u travnju.
SELECT 
	COUNT(*) AS N'Broj filmova posuenih u travnju'
	FROM Posudba
		WHERE MONTH(DatumPosudbe)=4
GO

-- 6. Ispiite sve filmove koji su vraeni nakon vie od 2 dana.
-- varijanta 1
SELECT
	Posudba.*,
	CAST((DatumVracanja-DatumPosudbe) AS INT) AS N'Razlika vraanja i posudbe'
	FROM Posudba
		WHERE CAST((DatumVracanja-DatumPosudbe) AS INT) > 2
GO
-- varijanta 2
SELECT
	Posudba.*,
	DATEDIFF(day,DatumPosudbe,DatumVracanja) AS N'Razlika vraanja i posudbe'
	FROM Posudba
		WHERE DATEDIFF(day,DatumPosudbe,DatumVracanja) > 2
GO

-- 7. Vratite je li 'danas' ispravan datum.
SELECT ISDATE('danas')
GO
 
-- 8. Vratite je li '2011-08-15' ispravan datum.
SELECT ISDATE('2011-08-15')
GO

-- 9. Vratite je li '15.08.2011.' ispravan datum.
SELECT ISDATE('15.08.2011.')
GO

-- 10. Vratite je li 'abcd' ispravan broj. 
SELECT ISNUMERIC('abcd')
GO

-- 11. Vratite je li '67.55' ispravan broj.
SELECT ISNUMERIC('67.55')
GO
 
-- 12. Vratite je li '67,55' ispravan broj.
SELECT ISNUMERIC('67,55')
GO
 
-- 13. Vratite nazive svih posuenih filmova i uz svaki ispiite datum vraanja ako je vraen, odnosno "NIJE VRAEN" ako nije.
SELECT
	Film.Naziv,
	ISNULL(CAST(Posudba.DatumVracanja AS CHAR), 'NIJE VRAEN') AS 'Datum vraanja'
FROM Film
INNER JOIN Posudba ON Posudba.FilmID = Film.ID


-- 14. Ispiite ukupnu vrijednost rauna izdanih u svibnju 2004
select
sum(s.UkupnaCijena)
from Racun as r
inner join Stavka as s on s.RacunID = r.IDRacun
where year(r.DatumIzdavanja) = 2004
and month(r.DatumIzdavanja) = 5


-- 15. Ispiite koliko proizvoda nema upisanu boju.
select count(*) as BrojProizvodaBezBoje
from proizvod
where boja is null

-- 16. Ispiite broj kupaca iz pojedinog grada, sortirano padajue po broju kupaca.
select
Grad.Naziv,
COUNT(IDKupac) AS BrojKupaca
from Kupac
inner join Grad on Grad.IDGrad = Kupac.GradID
group by Grad.Naziv
order by BrojKupaca DESC




